/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.infrastructure.particle.CubeParticleRenderer;
import java.util.Arrays;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_4588;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class CubeParticleSubmittable
implements class_11659.class_11947,
class_11942 {
    public static final Vector3f[] CUBE = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f)};
    private final Vertices vertices = new Vertices();
    private int particles;

    public void render(float x, float y, float z, float scale, int color) {
        this.vertices.vertex(x, y, z, scale, color);
        ++this.particles;
    }

    public void method_74316() {
        this.vertices.reset();
        this.particles = 0;
    }

    public class_11944.class_12041 method_74755(class_11977.class_12051 cache) {
        int i = this.particles * 24;
        try (class_9799 bufferAllocator = class_9799.method_72201((int)(i * class_290.field_1584.getVertexSize()));){
            class_287 bufferBuilder = new class_287(bufferAllocator, VertexFormat.class_5596.field_27382, class_290.field_1584);
            this.vertices.render((x, y, z, scale, color) -> this.drawFace((class_4588)bufferBuilder, x, y, z, scale, color));
            class_11944.class_12042 layer = new class_11944.class_12042(0, this.vertices.nextVertexIndex() * 36);
            class_9801 builtBuffer = bufferBuilder.method_60794();
            if (builtBuffer != null) {
                cache.method_74835(builtBuffer.method_60818());
                RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(builtBuffer.method_60822().comp_751());
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
                class_11944.class_12041 class_120412 = new class_11944.class_12041(builtBuffer.method_60822().comp_751(), gpuBufferSlice, Map.of(CubeParticleRenderer.RENDER_TYPE, layer));
                return class_120412;
            }
        }
        return null;
    }

    private void drawFace(class_4588 buffer, float x, float y, float z, float scale, int color) {
        int light = 0xF000F0;
        Vector3f vec = new Vector3f();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                CUBE[i * 4 + j].mul(scale, vec).add(x, y, z);
                buffer.method_22912(vec.x, vec.y, vec.z).method_22913((float)j / 2.0f, (float)(j % 2)).method_39415(color).method_60803(light);
            }
        }
    }

    public void method_74324(class_11944.class_12041 buffers, class_11977.class_12051 cache, RenderPass renderPass, class_1060 manager, boolean translucent) {
        if (translucent) {
            return;
        }
        RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        renderPass.setVertexBuffer(0, cache.method_74834());
        renderPass.setIndexBuffer(shapeIndexBuffer.method_68274(buffers.comp_4897()), shapeIndexBuffer.method_31924());
        renderPass.setUniform("DynamicTransforms", buffers.comp_4898());
        for (Map.Entry entry : buffers.comp_4899().entrySet()) {
            renderPass.setPipeline(((class_3940.class_11941)entry.getKey()).comp_4896());
            class_1044 texture = manager.method_4619(((class_3940.class_11941)entry.getKey()).comp_4895());
            renderPass.bindTexture("Sampler0", texture.method_71659(), texture.method_75484());
            renderPass.drawIndexed(0, 0, ((class_11944.class_12042)entry.getValue()).comp_4901(), 1);
        }
    }

    public void submit(class_11659 queue, class_12075 cameraRenderState) {
        if (this.particles > 0) {
            queue.method_74315((class_11659.class_11947)this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Vertices {
        private int maxVertices = 1024;
        private float[] floatData = new float[12288];
        private int[] intData = new int[2048];
        private int nextVertexIndex;

        public void vertex(float x, float y, float z, float scale, int color) {
            if (this.nextVertexIndex >= this.maxVertices) {
                this.increaseCapacity();
            }
            int i = this.nextVertexIndex * 4;
            this.floatData[i++] = x;
            this.floatData[i++] = y;
            this.floatData[i++] = z;
            this.floatData[i] = scale;
            this.intData[this.nextVertexIndex * 2] = color;
            ++this.nextVertexIndex;
        }

        public void render(Consumer consumer) {
            for (int i = 0; i < this.nextVertexIndex; ++i) {
                int j = i * 4;
                consumer.consume(this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j], this.intData[i]);
            }
        }

        public void reset() {
            this.nextVertexIndex = 0;
        }

        private void increaseCapacity() {
            this.maxVertices *= 2;
            this.floatData = Arrays.copyOf(this.floatData, this.maxVertices * 4);
            this.intData = Arrays.copyOf(this.intData, this.maxVertices);
        }

        public int nextVertexIndex() {
            return this.nextVertexIndex;
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Consumer {
        public void consume(float var1, float var2, float var3, float var4, int var5);
    }
}

